import io
import logging
from urllib import request
import oci
import base64
import json
from atlassian import ServiceDesk



def handler(ctx, data: io.BytesIO = None):
    [logging.getLogger(name).setLevel(logging.WARNING)
    for name in logging.root.manager.loggerDict]
    cfg = ctx.Config()
    signer = oci.auth.signers.get_resource_principals_signer()
    body = json.loads(data.getvalue())
    
    try:
        jsm_token = cfg["api-token"]
        jsm_user = cfg["api-user"]
        vault_OCID = cfg["vault_ocid"]
        service_desk_id = cfg["service_desk_id"]
        request_type_id = cfg["request_type_id"]
    except:
        logging.error('Some of the function config keys are not set')
        raise
    jsm_auth_key = decodeSecret(p_signer=signer, p_secretName=jsm_token, p_vaultOCID=vault_OCID)
    jsm_jsm_user = decodeSecret(p_signer=signer, p_secretName=jsm_user, p_vaultOCID=vault_OCID)

    if body['type'] == "OK_TO_FIRING":
        create_ticket(jsm_jsm_user, jsm_auth_key, service_desk_id, request_type_id, body)
        logging.info('create ticket function executed')


def create_ticket(user, password, service_desk_id, request_type_id, body):
    sd = ServiceDesk(url = "https://dranicu.atlassian.net", username = user, password = password, cloud=True)
    logging.info('before the try block')
    try:
        sd.create_customer_request(service_desk_id=int(service_desk_id), request_type_id=int(request_type_id), values_dict={"summary": body['title'], "description": body['body']})
        logging.info('Ticket created')
    except Exception as e:
        logging.error('Error creating ticket')
        logging.error(e)

def decodeSecret(p_signer, p_secretName, p_vaultOCID):
    secretClient = oci.secrets.SecretsClient(config={}, signer=p_signer)
    secret = secretClient.get_secret_bundle_by_name(
        secret_name=p_secretName, vault_id=p_vaultOCID).data
    secret_content = secret.secret_bundle_content.content.encode("utf-8")
    decodedSecret = base64.b64decode(secret_content).decode("utf-8")
    return decodedSecret

